/*
			       Tool Bar
 */

#ifndef TOOLBAR_H
#define TOOLBAR_H

#include <gtk/gtk.h>


typedef struct _toolbar_item_struct	toolbar_item_struct;
#define TOOLBAR_ITEM(p)			((toolbar_item_struct *)(p))
typedef struct _toolbar_struct		toolbar_struct;
#define TOOLBAR(p)			((toolbar_struct *)(p))


/*
 *	Tool Bar Item Types:
 */
typedef enum {
	TOOLBAR_ITEM_SEPARATOR,
	TOOLBAR_ITEM_BUTTON,
	TOOLBAR_ITEM_TOGGLE_BUTTON,
	TOOLBAR_ITEM_MENU_BUTTON
} toolbar_item_type;


/*
 *	Tool Bar Display:
 */
typedef enum {
	TOOLBAR_DISPLAY_TEXT,
	TOOLBAR_DISPLAY_PICTURES,
	TOOLBAR_DISPLAY_PICTURES_AND_TEXT
} toolbar_display;


/*
 *	Tool Bar Relief:
 */
typedef enum {
	TOOLBAR_RELIEF_NORMAL,
	TOOLBAR_RELIEF_HALF,
	TOOLBAR_RELIEF_NONE
} toolbar_relief;


/*
 *	Tool Bar Item:
 */
struct _toolbar_item_struct {

	toolbar_item_type	type;
	gint		freeze_count;
	toolbar_struct	*tb;
	GtkWidget	*w;		/* Toplevel GtkWidget */
	gchar		*text;		/* Label */
	guint8		**icon_data;	/* Item icon data (shared) */
	gchar		*tooltip;
	gint		id;		/* Client ID code */

	/* Function callbacks, sole argument is the respective
	 * client_data
	 */

	/* "clicked" or "toggled" callback */
	void	(*func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* Data */
	);
	gpointer	func_data;

	/* "enter_notify_event" and "leave_notify_event" callbacks */
	void	(*enter_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* Data */
	);
	gpointer	enter_data;
	void	(*leave_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* Data */
	);
	gpointer	leave_data;

};


/*
 *	Tool Bar:
 */
struct _toolbar_struct {

	GtkWidget	*toplevel;	/* GtkBox */
	gint		freeze_count;

	toolbar_display	display;
	toolbar_relief	relief;
	GtkOrientation	orientation;

	GList		*items_list;

};


/* Item */
extern toolbar_item_struct *ToolBarItemNew(
	const toolbar_item_type type,
	toolbar_struct *tb,
	const gchar *text,
	guint8 **icon_data,
	const gchar *tooltip,
	const gint id,
	void (*func_cb)(toolbar_item_struct *, gint, gpointer),
	gpointer func_data,
	void (*enter_cb)(toolbar_item_struct *, gint, gpointer),
	gpointer enter_data,
	void (*leave_cb)(toolbar_item_struct *, gint, gpointer),
	gpointer leave_data
);
extern void ToolBarItemDelete(toolbar_item_struct *item);

extern toolbar_item_struct *ToolBarItemListMatchByID(
	GList *items_list, const gint id
);


/* Tool Bar */
extern toolbar_struct *ToolBarNew(
	GtkWidget *parent,
	GList *items_list,
	const toolbar_display display,
	const toolbar_relief relief,
	const GtkOrientation orientation
);
extern void ToolBarSetDisplay(
	toolbar_struct *tb, const toolbar_display display
);
extern void ToolBarSetRelief(
	toolbar_struct *tb, const toolbar_relief relief
);
extern void ToolBarItemUpdateByID(
	toolbar_struct *tb, const gint id,
	const gchar *text,
	guint8 **icon_data,
	const gchar *tooltip
);
extern void ToolBarMap(toolbar_struct *tb);
extern void ToolBarUnmap(toolbar_struct *tb);
extern void ToolBarDelete(toolbar_struct *tb);


/* Tool Bar Item */
extern GtkWidget *ToolBarItemGetWidgetID(
	toolbar_struct *tb, const gint id
);
extern void ToolBarItemSetSensitiveID(
	toolbar_struct *tb, const gint id,
	const gboolean sensitive
);
extern void ToolBarItemSetToggleID(
	toolbar_struct *tb, const gint id,
	const gboolean toggled
);
extern gboolean ToolBarItemGetToggleID(
	toolbar_struct *tb, const gint id
);
extern void ToolBarItemSetMenuID(
	toolbar_struct *tb, const gint id,
	GtkWidget *menu
);
extern GtkWidget *ToolBarItemGetMenuID(
	toolbar_struct *tb, const gint id
);
extern gboolean ToolBarItemIsMappedID(
	toolbar_struct *tb, const gint id
);
extern void ToolBarItemMapID(
	toolbar_struct *tb, const gint id
);
extern void ToolBarItemUnmapID(
	toolbar_struct *tb, const gint id
);


#endif	/* TOOLBAR_H */

