
#include "showinfo.h"
#include "meta.h"
#include "acbuf.h"
#include "acfg.h"

//#include <iostream>

using namespace MYSTD;

#define USERINFO_TEMPLATE "userinfo.html"

// some NOOPs
showinfo::showinfo(int fd) :
	maintenance(fd)
{
}

showinfo::~showinfo()
{
}

/// Not used, overriding Run
void showinfo::Action(const MYSTD::string & src)
{
}

void showinfo::Run(const string &)
{
	SendDecoration(true, "404", NULL);

	acbuf pagebuf;
	if(	! pagebuf.initFromFile((acfg::confdir+sPathSep+USERINFO_TEMPLATE).c_str()))
	{
		SendMsg("Information about APT configuration not available, please contact the system administrator.");
	}
	else
	{
		string contents(pagebuf.rptr(), pagebuf.size());
		SetStyle(contents);
		StrSubst(contents, "$SERVERIP", GetHostname());
		StrSubst(contents, "$SERVERPORT", acfg::port.c_str());
		StrSubst(contents, "$REPAGE", sPathSepUnix+acfg::reportpage);
		
		SendMsg(contents);
	}
	SendDecoration(false);
}
