/*
 * Copyright (C) 2010 Motorola
 * Copyright (C) 2011-2012 Canonical, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef ANDROID_AUDIO_WRAPPER_DEFINE_H
#define ANDROID_AUDIO_WRAPPER_DEFINE_H


#define ANDROID_AUDIO_WRAPPER_ERROR_START 0x9000000

typedef unsigned long uint32;
typedef int status_type;
typedef void* TrackHandle;
typedef void* RecordHandle;
typedef void (*callback_t)(int event, void* user, void *info);

enum{
    OK = 0,
    NO_ERROR = 0,
    //UNKNOWN_ERROR,
    //INIT_FAIL = -ENODEV, 
    INVALID_PARAM = ANDROID_AUDIO_WRAPPER_ERROR_START
};

typedef enum _stream_type {
    DEFAULT = -1,
    VOICE_CALL = 0,
    SYSTEM = 1,
    RING = 2,
    MUSIC = 3,
    ALARM = 4,
    NOTIFICATION = 5,
    BLUETOOTH_SCO = 6,
    ENFORCED_AUDIBLE = 7,
    DTMF = 8,
    TTS = 9,
    NUM_STREAM_TYPES
} stream_type;

// Audio sub formats (see AudioSystem::audio_format).
enum pcm_sub_format {
    PCM_SUB_16_BIT          = 0x1, // must be 1 for backward compatibility
    PCM_SUB_8_BIT           = 0x2, // must be 2 for backward compatibility
};

// Audio format consists in a main format field (upper 8 bits) and a sub format field (lower 24 bits).
// The main format indicates the main codec type. The sub format field indicates options and parameters
// for each format. The sub format is mainly used for record to indicate for instance the requested bitrate
// or profile. It can also be used for certain formats to give informations not present in the encoded
// audio stream (e.g. octet alignement for AMR).
typedef enum _audio_format {
    INVALID_FORMAT      = -1,
    FORMAT_DEFAULT      = 0,
    PCM                 = 0x00000000, // must be 0 for backward compatibility
    MP3                 = 0x01000000,
    AMR_NB              = 0x02000000,
    AMR_WB              = 0x03000000,
    AAC                 = 0x04000000,
    HE_AAC_V1           = 0x05000000,
    HE_AAC_V2           = 0x06000000,
    VORBIS              = 0x07000000,
    MAIN_FORMAT_MASK    = 0xFF000000,
    SUB_FORMAT_MASK     = 0x00FFFFFF,
    // Aliases
    PCM_16_BIT          = (PCM|PCM_SUB_16_BIT),
    PCM_8_BIT          = (PCM|PCM_SUB_8_BIT)
} audio_format;

// Channel mask definitions must be kept in sync with JAVA values in /media/java/android/media/AudioFormat.java
typedef enum _audio_channels {
    // output channels
    CHANNEL_OUT_FRONT_LEFT = 0x4,
    CHANNEL_OUT_FRONT_RIGHT = 0x8,
    CHANNEL_OUT_FRONT_CENTER = 0x10,
    CHANNEL_OUT_LOW_FREQUENCY = 0x20,
    CHANNEL_OUT_BACK_LEFT = 0x40,
    CHANNEL_OUT_BACK_RIGHT = 0x80,
    CHANNEL_OUT_FRONT_LEFT_OF_CENTER = 0x100,
    CHANNEL_OUT_FRONT_RIGHT_OF_CENTER = 0x200,
    CHANNEL_OUT_BACK_CENTER = 0x400,
    CHANNEL_OUT_MONO = CHANNEL_OUT_FRONT_LEFT,
    CHANNEL_OUT_STEREO = (CHANNEL_OUT_FRONT_LEFT | CHANNEL_OUT_FRONT_RIGHT),
    CHANNEL_OUT_QUAD = (CHANNEL_OUT_FRONT_LEFT | CHANNEL_OUT_FRONT_RIGHT |
    CHANNEL_OUT_BACK_LEFT | CHANNEL_OUT_BACK_RIGHT),
    CHANNEL_OUT_SURROUND = (CHANNEL_OUT_FRONT_LEFT | CHANNEL_OUT_FRONT_RIGHT |
    CHANNEL_OUT_FRONT_CENTER | CHANNEL_OUT_BACK_CENTER),
    CHANNEL_OUT_5POINT1 = (CHANNEL_OUT_FRONT_LEFT | CHANNEL_OUT_FRONT_RIGHT |
    CHANNEL_OUT_FRONT_CENTER | CHANNEL_OUT_LOW_FREQUENCY | CHANNEL_OUT_BACK_LEFT | CHANNEL_OUT_BACK_RIGHT),
    CHANNEL_OUT_7POINT1 = (CHANNEL_OUT_FRONT_LEFT | CHANNEL_OUT_FRONT_RIGHT |
    CHANNEL_OUT_FRONT_CENTER | CHANNEL_OUT_LOW_FREQUENCY | CHANNEL_OUT_BACK_LEFT | CHANNEL_OUT_BACK_RIGHT |
    CHANNEL_OUT_FRONT_LEFT_OF_CENTER | CHANNEL_OUT_FRONT_RIGHT_OF_CENTER),
    CHANNEL_OUT_ALL = (CHANNEL_OUT_FRONT_LEFT | CHANNEL_OUT_FRONT_RIGHT |
    CHANNEL_OUT_FRONT_CENTER | CHANNEL_OUT_LOW_FREQUENCY | CHANNEL_OUT_BACK_LEFT | CHANNEL_OUT_BACK_RIGHT |
    CHANNEL_OUT_FRONT_LEFT_OF_CENTER | CHANNEL_OUT_FRONT_RIGHT_OF_CENTER | CHANNEL_OUT_BACK_CENTER),

    // input channels
    CHANNEL_IN_LEFT = 0x4,
    CHANNEL_IN_RIGHT = 0x8,
    CHANNEL_IN_FRONT = 0x10,
    CHANNEL_IN_BACK = 0x20,
    CHANNEL_IN_LEFT_PROCESSED = 0x40,
    CHANNEL_IN_RIGHT_PROCESSED = 0x80,
    CHANNEL_IN_FRONT_PROCESSED = 0x100,
    CHANNEL_IN_BACK_PROCESSED = 0x200,
    CHANNEL_IN_PRESSURE = 0x400,
    CHANNEL_IN_X_AXIS = 0x800,
    CHANNEL_IN_Y_AXIS = 0x1000,
    CHANNEL_IN_Z_AXIS = 0x2000,
    CHANNEL_IN_VOICE_UPLINK = 0x4000,
    CHANNEL_IN_VOICE_DNLINK = 0x8000,
    CHANNEL_IN_MONO = CHANNEL_IN_FRONT,
    CHANNEL_IN_STEREO = (CHANNEL_IN_LEFT | CHANNEL_IN_RIGHT),
    CHANNEL_IN_ALL = (CHANNEL_IN_LEFT | CHANNEL_IN_RIGHT | CHANNEL_IN_FRONT | CHANNEL_IN_BACK|
    CHANNEL_IN_LEFT_PROCESSED | CHANNEL_IN_RIGHT_PROCESSED | CHANNEL_IN_FRONT_PROCESSED | CHANNEL_IN_BACK_PROCESSED|
    CHANNEL_IN_PRESSURE | CHANNEL_IN_X_AXIS | CHANNEL_IN_Y_AXIS | CHANNEL_IN_Z_AXIS |
    CHANNEL_IN_VOICE_UPLINK | CHANNEL_IN_VOICE_DNLINK)
} audio_channels;


#endif
