/*
 * Copyright (C) 2012 Canonical, Ltd.
 *
 * Authors:
 *  Renato Araujo Oliveira Filho <renato@canonical.com>
 *  Ricardo Mendoza <ricmm@canonical.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ANDROID_ACCOUNT_MANAGER_PROXY_H
#define ANDROID_ACCOUNT_MANAGER_PROXY_H

#include "account-info.h"

#include <glib.h>
#include <glib-object.h>


#define TYPE_ANDROID_ACCOUNT_MANAGER_PROXY \
    (android_account_manager_proxy_get_type ())
#define ANDROID_ACCOUNT_MANAGER_PROXY(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANDROID_ACCOUNT_MANAGER_PROXY, AndroidAccountManagerProxy))
#define ANDROID_ACCOUNT_MANAGER_PROXY_CLASS(cls) \
    (G_TYPE_CHECK_CLASS_CAST ((cls), TYPE_ANDROID_ACCOUNT_MANAGER_PROXY, AndroidAccountManagerProxyClass))
#define IS_ANDROID_ACCOUNT_MANAGER_PROXY(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANDROID_ACCOUNT_MANAGER_PROXY))
#define IS_ANDROID_ACCOUNT_MANAGER_PROXY_CLASS(cls) \
    (G_TYPE_CHECK_CLASS_TYPE ((cls), TYPE_ANDROID_ACCOUNT_MANAGER_PROXY))
#define ANDROID_ACCOUNT_MANAGER_PROXY_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANDROID_ACCOUNT_MANAGER_PROXY, AndroidAccountManagerProxyClass))

G_BEGIN_DECLS

#define NUM_FIELDS  8

typedef struct _AndroidAccountManagerProxy AndroidAccountManagerProxy;
typedef struct _AndroidAccountManagerProxyClass AndroidAccountManagerProxyClass;
typedef struct _AndroidAccountManagerProxyPrivate AndroidAccountManagerProxyPrivate;

struct _AndroidAccountManagerProxy {
    GObject parent_instance;
    AndroidAccountManagerProxyPrivate *priv;
};

struct _AndroidAccountManagerProxyClass {
    GObjectClass parent_class;

    void (* account_updated) (AndroidAccountManagerProxy *self, const char *email, unsigned long update_mask);
    void (* account_removed) (AndroidAccountManagerProxy *self, const char *email);
    void (* account_created) (AndroidAccountManagerProxy *self, const char *email);
};

AndroidAccountManagerProxy* android_account_manager_proxy_new                   (void);
GType                       android_account_manager_proxy_get_type              (void);
void                        android_account_manager_proxy_start_sync            (AndroidAccountManagerProxy *self);
void                        android_account_manager_proxy_register_account      (AndroidAccountManagerProxy *self,
                                                                                 AccountInfo *info);
void                        android_account_manager_proxy_unregister_account    (AndroidAccountManagerProxy *self,
                                                                                 const gchar *email);
void                        android_account_manager_proxy_update_account        (AndroidAccountManagerProxy *self,
                                                                                 AccountInfo *account);
void                        android_account_manager_proxy_create_account        (AndroidAccountManagerProxy *self,
                                                                                 AccountInfo *account);
void                        android_account_manager_proxy_handle_update         (AndroidAccountManagerProxy *self,
                                                                                 AccountInfo *server,
                                                                                 AccountInfo *local);
const AccountInfo*          android_account_manager_proxy_get_account           (AndroidAccountManagerProxy *self,
                                                                                 const gchar *email);

G_END_DECLS

#endif
